# # Describing the changing positions of parties

library(RKernel)


library(magrittr)
library(memisc)



load("CHESwork.RData")


CHESwork %<>% within({
  ChristCons <- recode(partfam,
    "Confessional" <- 10,
    "Christian democratic" <- 4,
    "Conservative" <- 2,
    "Radical Right" <- 1,
    "Other" <- c(3,5:9,11),
  )
  Western.Europe <- country %in% c(1,2,3,5,6,7,8,10,11,12,13,14,16,38)
})


library(ggplot2)


(g.GALTAN <- ggplot(subset(CHESwork,Western.Europe)) + 
   geom_boxplot(aes(y=galtan,x=ChristCons),fill="gray80") +
   theme_bw() +
   theme(legend.position = "none",
         axis.text.x=element_text(angle=90,
                                  vjust=.5,
                                  hjust=1)) + 
   labs(x="",y="GAL/TAN"))


ls(CHESwork)


CHESw_long <- Reshape(subset(CHESwork,Western.Europe),
                      Position=c(galtan,religious_principles,sociallifestyle,lrecon,immigration),
                      Dimension=c("GAL–TAN","Religious Principles","Social Lifestyle","Economic Left–Right","Immigration"),
                      direction="long")
CHESe_long <- Reshape(subset(CHESwork,!Western.Europe),
                      Position=c(galtan,religious_principles,sociallifestyle,lrecon,immigration),
                      Dimension=c("GAL–TAN","Religious Principles","Social Lifestyle","Economic Left–Right","Immigration"),
                      direction="long")
#summary(CHESw_long)


#!cell_opt: jupyter.plot.width=8,jupyter.plot.height=4
ggplot(CHESw_long) + 
   geom_boxplot(aes(y=Position,x=ChristCons),fill="gray90") +
   facet_grid(~Dimension) +
   theme_bw() +
   theme(legend.position = "none",
         axis.text.x=element_text(angle=90,
                                  vjust=.5,
                                  hjust=1)) +
    labs(x="")
ggsave(file="boxplot-partfam-dimensions-we.pdf",width=8,height=4)
ggsave(file="boxplot-partfam-dimensions-we.svg",width=8,height=4)


#!cell_opt: jupyter.plot.width=8,jupyter.plot.height=4
ggplot(CHESe_long) + 
   geom_boxplot(aes(y=Position,x=ChristCons,fill=ChristCons)) +
   facet_grid(~Dimension) +
   theme_bw() +
   theme(legend.position = "none",
         axis.text.x=element_text(angle=90,
                                  vjust=.5,
                                  hjust=1)) +
    labs(x="")
#ggsave(file="boxplot-partfam-dimensions-we.pdf")
#ggsave(file="boxplot-partfam-dimensions-we.svg")


#!cell_opt: jupyter.plot.width=8,jupyter.plot.height=4
ggplot(CHESw_long) + 
   geom_boxplot(aes(y=Position,x=Dimension,fill=ChristCons)) +
   facet_grid(~ChristCons) +
   theme_bw() +
   theme(legend.position = "none",
         axis.text.x=element_text(angle=90,
                                  vjust=.5,
                                  hjust=1)) +
    labs(x="")




